"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AvailableRatePlansSinglePage = exports.Plans = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Plans extends resource_1.APIResource {
    /**
     * Lists available plans the zone can subscribe to.
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/available_plans`, AvailableRatePlansSinglePage, options);
    }
    /**
     * Details of the available plan that the zone can subscribe to.
     */
    get(planIdentifier, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/available_plans/${planIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Plans = Plans;
class AvailableRatePlansSinglePage extends pagination_1.SinglePage {
}
exports.AvailableRatePlansSinglePage = AvailableRatePlansSinglePage;
Plans.AvailableRatePlansSinglePage = AvailableRatePlansSinglePage;
//# sourceMappingURL=plans.js.map