// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Plans extends APIResource {
    /**
     * Lists available plans the zone can subscribe to.
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/available_plans`, AvailableRatePlansSinglePage, options);
    }
    /**
     * Details of the available plan that the zone can subscribe to.
     */
    get(planIdentifier, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/available_plans/${planIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class AvailableRatePlansSinglePage extends SinglePage {
}
Plans.AvailableRatePlansSinglePage = AvailableRatePlansSinglePage;
//# sourceMappingURL=plans.mjs.map