"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.RatePlanGetResponsesSinglePage = exports.RatePlans = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class RatePlans extends resource_1.APIResource {
    /**
     * Lists all rate plans the zone can subscribe to.
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/available_rate_plans`, RatePlanGetResponsesSinglePage, options);
    }
}
exports.RatePlans = RatePlans;
class RatePlanGetResponsesSinglePage extends pagination_1.SinglePage {
}
exports.RatePlanGetResponsesSinglePage = RatePlanGetResponsesSinglePage;
RatePlans.RatePlanGetResponsesSinglePage = RatePlanGetResponsesSinglePage;
//# sourceMappingURL=rate-plans.js.map