// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class Settings extends APIResource {
    /**
     * Updates a single zone setting by the identifier
     */
    edit(settingId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/settings/${settingId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a single zone setting by name
     */
    get(settingId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/settings/${settingId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=settings.mjs.map