import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import * as Shared from "../shared.js";
export declare class Subscriptions extends APIResource {
    /**
     * Create a zone subscription, either plan or add-ons.
     */
    create(identifier: string, body: SubscriptionCreateParams, options?: Core.RequestOptions): Core.APIPromise<SubscriptionCreateResponse>;
    /**
     * Updates zone subscriptions, either plan or add-ons.
     */
    update(identifier: string, body: SubscriptionUpdateParams, options?: Core.RequestOptions): Core.APIPromise<SubscriptionUpdateResponse>;
    /**
     * Lists zone subscription details.
     */
    get(identifier: string, options?: Core.RequestOptions): Core.APIPromise<SubscriptionGetResponse>;
}
export type SubscriptionCreateResponse = unknown | string | null;
export type SubscriptionUpdateResponse = unknown | string | null;
export type SubscriptionGetResponse = unknown | string | null;
export interface SubscriptionCreateParams {
    /**
     * How often the subscription is renewed automatically.
     */
    frequency?: 'weekly' | 'monthly' | 'quarterly' | 'yearly';
    /**
     * The rate plan applied to the subscription.
     */
    rate_plan?: Shared.RatePlanParam;
}
export interface SubscriptionUpdateParams {
    /**
     * How often the subscription is renewed automatically.
     */
    frequency?: 'weekly' | 'monthly' | 'quarterly' | 'yearly';
    /**
     * The rate plan applied to the subscription.
     */
    rate_plan?: Shared.RatePlanParam;
}
export declare namespace Subscriptions {
    export { type SubscriptionCreateResponse as SubscriptionCreateResponse, type SubscriptionUpdateResponse as SubscriptionUpdateResponse, type SubscriptionGetResponse as SubscriptionGetResponse, type SubscriptionCreateParams as SubscriptionCreateParams, type SubscriptionUpdateParams as SubscriptionUpdateParams, };
}
//# sourceMappingURL=subscriptions.d.ts.map