"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Subscriptions = void 0;
const resource_1 = require("../../resource.js");
class Subscriptions extends resource_1.APIResource {
    /**
     * Create a zone subscription, either plan or add-ons.
     */
    create(identifier, body, options) {
        return this._client.post(`/zones/${identifier}/subscription`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates zone subscriptions, either plan or add-ons.
     */
    update(identifier, body, options) {
        return this._client.put(`/zones/${identifier}/subscription`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists zone subscription details.
     */
    get(identifier, options) {
        return this._client.get(`/zones/${identifier}/subscription`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Subscriptions = Subscriptions;
//# sourceMappingURL=subscriptions.js.map