// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class Subscriptions extends APIResource {
    /**
     * Create a zone subscription, either plan or add-ons.
     */
    create(identifier, body, options) {
        return this._client.post(`/zones/${identifier}/subscription`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates zone subscriptions, either plan or add-ons.
     */
    update(identifier, body, options) {
        return this._client.put(`/zones/${identifier}/subscription`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists zone subscription details.
     */
    get(identifier, options) {
        return this._client.get(`/zones/${identifier}/subscription`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=subscriptions.mjs.map