// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

import { APIResource } from '../../../../resource';
import * as SummaryAPI from './summary';
import {
  Summary,
  SummaryARCParams,
  SummaryARCResponse,
  SummaryDKIMParams,
  SummaryDKIMResponse,
  SummaryDMARCParams,
  SummaryDMARCResponse,
  SummaryMaliciousParams,
  SummaryMaliciousResponse,
  SummarySPFParams,
  SummarySPFResponse,
  SummarySpamParams,
  SummarySpamResponse,
  SummarySpoofParams,
  SummarySpoofResponse,
  SummaryTLSVersionParams,
  SummaryTLSVersionResponse,
  SummaryThreatCategoryParams,
  SummaryThreatCategoryResponse,
} from './summary';
import * as TimeseriesGroupsAPI from './timeseries-groups';
import {
  TimeseriesGroupARCParams,
  TimeseriesGroupARCResponse,
  TimeseriesGroupDKIMParams,
  TimeseriesGroupDKIMResponse,
  TimeseriesGroupDMARCParams,
  TimeseriesGroupDMARCResponse,
  TimeseriesGroupMaliciousParams,
  TimeseriesGroupMaliciousResponse,
  TimeseriesGroupSPFParams,
  TimeseriesGroupSPFResponse,
  TimeseriesGroupSpamParams,
  TimeseriesGroupSpamResponse,
  TimeseriesGroupSpoofParams,
  TimeseriesGroupSpoofResponse,
  TimeseriesGroupTLSVersionParams,
  TimeseriesGroupTLSVersionResponse,
  TimeseriesGroupThreatCategoryParams,
  TimeseriesGroupThreatCategoryResponse,
  TimeseriesGroups,
} from './timeseries-groups';
import * as TopAPI from './top/top';
import { Top } from './top/top';

export class Security extends APIResource {
  top: TopAPI.Top = new TopAPI.Top(this._client);
  summary: SummaryAPI.Summary = new SummaryAPI.Summary(this._client);
  timeseriesGroups: TimeseriesGroupsAPI.TimeseriesGroups = new TimeseriesGroupsAPI.TimeseriesGroups(
    this._client,
  );
}

Security.Top = Top;
Security.Summary = Summary;
Security.TimeseriesGroups = TimeseriesGroups;

export declare namespace Security {
  export { Top as Top };

  export {
    Summary as Summary,
    type SummaryARCResponse as SummaryARCResponse,
    type SummaryDKIMResponse as SummaryDKIMResponse,
    type SummaryDMARCResponse as SummaryDMARCResponse,
    type SummaryMaliciousResponse as SummaryMaliciousResponse,
    type SummarySpamResponse as SummarySpamResponse,
    type SummarySPFResponse as SummarySPFResponse,
    type SummarySpoofResponse as SummarySpoofResponse,
    type SummaryThreatCategoryResponse as SummaryThreatCategoryResponse,
    type SummaryTLSVersionResponse as SummaryTLSVersionResponse,
    type SummaryARCParams as SummaryARCParams,
    type SummaryDKIMParams as SummaryDKIMParams,
    type SummaryDMARCParams as SummaryDMARCParams,
    type SummaryMaliciousParams as SummaryMaliciousParams,
    type SummarySpamParams as SummarySpamParams,
    type SummarySPFParams as SummarySPFParams,
    type SummarySpoofParams as SummarySpoofParams,
    type SummaryThreatCategoryParams as SummaryThreatCategoryParams,
    type SummaryTLSVersionParams as SummaryTLSVersionParams,
  };

  export {
    TimeseriesGroups as TimeseriesGroups,
    type TimeseriesGroupARCResponse as TimeseriesGroupARCResponse,
    type TimeseriesGroupDKIMResponse as TimeseriesGroupDKIMResponse,
    type TimeseriesGroupDMARCResponse as TimeseriesGroupDMARCResponse,
    type TimeseriesGroupMaliciousResponse as TimeseriesGroupMaliciousResponse,
    type TimeseriesGroupSpamResponse as TimeseriesGroupSpamResponse,
    type TimeseriesGroupSPFResponse as TimeseriesGroupSPFResponse,
    type TimeseriesGroupSpoofResponse as TimeseriesGroupSpoofResponse,
    type TimeseriesGroupThreatCategoryResponse as TimeseriesGroupThreatCategoryResponse,
    type TimeseriesGroupTLSVersionResponse as TimeseriesGroupTLSVersionResponse,
    type TimeseriesGroupARCParams as TimeseriesGroupARCParams,
    type TimeseriesGroupDKIMParams as TimeseriesGroupDKIMParams,
    type TimeseriesGroupDMARCParams as TimeseriesGroupDMARCParams,
    type TimeseriesGroupMaliciousParams as TimeseriesGroupMaliciousParams,
    type TimeseriesGroupSpamParams as TimeseriesGroupSpamParams,
    type TimeseriesGroupSPFParams as TimeseriesGroupSPFParams,
    type TimeseriesGroupSpoofParams as TimeseriesGroupSpoofParams,
    type TimeseriesGroupThreatCategoryParams as TimeseriesGroupThreatCategoryParams,
    type TimeseriesGroupTLSVersionParams as TimeseriesGroupTLSVersionParams,
  };
}
