"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncTask = void 0;
const Logger_1 = require("./Logger");
const Utils_1 = require("./Utils");
class AsyncTask {
    constructor(id, handler, errorHandler) {
        this.id = id;
        this.handler = handler;
        this.errorHandler = errorHandler || (0, Logger_1.defaultErrorHandler)(this.id);
        this.isExecuting = false;
    }
    execute(jobId) {
        this.isExecuting = true;
        this.handler(this.id, jobId)
            .catch((err) => {
            const errorHandleResult = this.errorHandler(err);
            if ((0, Utils_1.isPromise)(errorHandleResult)) {
                // If we fail while handling an error, oh well
                errorHandleResult.catch((0, Logger_1.loggingErrorHandler)(err));
            }
        })
            .finally(() => {
            this.isExecuting = false;
        });
    }
}
exports.AsyncTask = AsyncTask;
//# sourceMappingURL=AsyncTask.js.map