import { Job, JobStatus } from '../../common/Job';
import { Task } from '../../common/Task';
import { AsyncTask } from '../../common/AsyncTask';
import { JobOptions } from '../simple-interval/SimpleIntervalJob';
export declare const CRON_EVERY_SECOND = "* * * * * *";
export declare const CRON_EVERY_30_SECONDS = "*/30 * * * * *";
export declare const CRON_EVERY_MINUTE = "* * * * *";
export declare const CRON_EVERY_30_MINUTES = "*/30 * * * *";
export declare const CRON_EVERY_HOUR = "0 * * * *";
export type CronSchedule = {
    cronExpression: string;
    timezone?: string;
};
export declare class CronJob extends Job {
    private readonly schedule;
    private readonly task;
    private readonly preventOverrun;
    private cronInstance;
    constructor(schedule: CronSchedule, task: Task | AsyncTask, options?: JobOptions);
    getStatus(): JobStatus;
    start(): void;
    stop(): void;
}
