"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CronJob = exports.CRON_EVERY_HOUR = exports.CRON_EVERY_30_MINUTES = exports.CRON_EVERY_MINUTE = exports.CRON_EVERY_30_SECONDS = exports.CRON_EVERY_SECOND = void 0;
const Job_1 = require("../../common/Job");
const croner_1 = require("croner");
exports.CRON_EVERY_SECOND = '* * * * * *';
exports.CRON_EVERY_30_SECONDS = '*/30 * * * * *';
exports.CRON_EVERY_MINUTE = '* * * * *';
exports.CRON_EVERY_30_MINUTES = '*/30 * * * *';
exports.CRON_EVERY_HOUR = '0 * * * *';
class CronJob extends Job_1.Job {
    constructor(schedule, task, options = {}) {
        super(options.id);
        this.preventOverrun = options.preventOverrun || false;
        this.schedule = schedule;
        this.task = task;
    }
    /* istanbul ignore next */
    getStatus() {
        var _a;
        return ((_a = this.cronInstance) === null || _a === void 0 ? void 0 : _a.isRunning()) ? Job_1.JobStatus.RUNNING : Job_1.JobStatus.STOPPED;
    }
    start() {
        this.cronInstance = (0, croner_1.Cron)(this.schedule.cronExpression, {
            timezone: this.schedule.timezone,
            protect: false,
        }, () => {
            if (!this.task.isExecuting || !this.preventOverrun) {
                this.task.execute(this.id);
            }
        });
    }
    /* istanbul ignore next */
    stop() {
        var _a;
        (_a = this.cronInstance) === null || _a === void 0 ? void 0 : _a.stop();
    }
}
exports.CronJob = CronJob;
//# sourceMappingURL=CronJob.js.map