"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleIntervalEngine = void 0;
const SchedulerEngine_1 = require("../../common/SchedulerEngine");
class SimpleIntervalEngine extends SchedulerEngine_1.SchedulerEngine {
    constructor() {
        super();
        this.jobs = [];
    }
    add(job) {
        this.jobs.push(job);
        job.start();
    }
    stop() {
        for (const job of this.jobs) {
            job.stop();
        }
    }
}
exports.SimpleIntervalEngine = SimpleIntervalEngine;
//# sourceMappingURL=SimpleIntervalEngine.js.map