import { FindOptionsWhere, Repository } from 'typeorm';
import { ETableName } from 'src/enums/base.enum';
import { ISearchQueryItem, SDKBaseService } from '@serene-dev/la-nest-library';
import { BaseEntity, SearchQueryDto } from 'src/entities/base.entity';
import { Chart, ChartItem, ChartQueryDto } from 'src/dtos/analytics.dto';
export declare class BaseService<TEntity extends BaseEntity, TSearchDto extends SearchQueryDto = SearchQueryDto> extends SDKBaseService<TEntity, TSearchDto> {
    protected readonly repo: Repository<BaseEntity>;
    tableName: ETableName;
    getAnalytics(params?: ChartQueryDto): Promise<Chart[]>;
    protected countExtractor<TTEntity = TEntity>(column: keyof TTEntity, repository?: Repository<TTEntity>): Promise<ChartItem[]>;
    protected countExtractor<TTEntity extends BaseEntity = TEntity>(queries: {
        label: string;
        where: FindOptionsWhere<TEntity | BaseEntity>[] | FindOptionsWhere<TEntity | BaseEntity>;
    }[], repository?: Repository<TTEntity>): Promise<ChartItem[]>;
    skipCreator: boolean;
    private idSearchQuery;
    get queryStruct(): ISearchQueryItem<TSearchDto>[];
    set queryStruct(value: ISearchQueryItem<TSearchDto>[]);
    constructor(repo: Repository<BaseEntity>, tableName: ETableName);
    extFormatSearchQuery: (query: TSearchDto) => Promise<TSearchDto>;
}
