"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardService = void 0;
const common_1 = require("@nestjs/common");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const admin_dashboard_entity_1 = require("../entities/views/dashboard/admin-dashboard.entity");
const schedule_1 = require("@nestjs/schedule");
const cache_manager_1 = require("@nestjs/cache-manager");
const common_2 = require("@nestjs/common");
let DashboardService = class DashboardService {
    constructor(repo, cacheManager) {
        this.repo = repo;
        this.cacheManager = cacheManager;
        this.DASHBOARD_CACHE_KEY = 'admin_dashboard_stats';
    }
    async getAdminDashboard() {
        const cachedData = await this.cacheManager.get(this.DASHBOARD_CACHE_KEY);
        if (cachedData) {
            return cachedData;
        }
        const data = await this.repo.find({
            take: 1,
        });
        await this.cacheManager.set(this.DASHBOARD_CACHE_KEY, data, 3600000);
        return data;
    }
    async updateDashboardCache() {
        try {
            const data = await this.repo.find({
                take: 1,
            });
            await this.cacheManager.set(this.DASHBOARD_CACHE_KEY, data, 3600000);
        }
        catch (error) {
            console.error('Failed to update dashboard cache:', error);
        }
    }
    async refreshDashboardStats() {
        const data = await this.repo.find({
            take: 1,
        });
        await this.cacheManager.set(this.DASHBOARD_CACHE_KEY, data, 3600000);
        return data;
    }
};
exports.DashboardService = DashboardService;
DashboardService.path = new la_nest_library_1.RoutePath('dashboard');
__decorate([
    (0, schedule_1.Cron)(schedule_1.CronExpression.EVERY_HOUR),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], DashboardService.prototype, "updateDashboardCache", null);
exports.DashboardService = DashboardService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(admin_dashboard_entity_1.AdminDashboardView)),
    __param(1, (0, common_2.Inject)(cache_manager_1.CACHE_MANAGER)),
    __metadata("design:paramtypes", [typeorm_1.Repository, Object])
], DashboardService);
//# sourceMappingURL=dashboard.service.js.map