import { ConfigService } from '@nestjs/config';
import { MulterModuleOptions } from '@nestjs/platform-express';
import { ISDKEnvironment, SDKEnvironmentService } from '@serene-dev/la-nest-library';
import { ETheme } from 'src/enums/theme.enum';
export declare class IEnvironment extends ISDKEnvironment {
    LOGS_DEST: string;
    THEME: ETheme;
    SYNCHRONIZE: boolean;
    timestampDifferenceFromGMT: number;
    APP_NAME: string;
    CA: string;
    CERT: string;
    KEY: string;
    PS_SECRET_KEY: string;
    PS_PUBLIC_KEY: string;
    UPLOADS_ABS_PATH: string;
    REALTIME_INTERVAL_MIN: number;
    R2_ACCOUNT_ID: string;
    R2_ACCESS_KEY_ID: string;
    R2_SECRET_ACCESS_KEY: string;
    R2_BUCKET_NAME: string;
    CLOUDFLARE_EMAIL: string;
    CLOUDFLARE_API_KEY: string;
    CLOUDFLARE_ACCOUNT_ID: string;
    FFMPEG_PATH: string;
    FFPROBE_PATH: string;
}
export declare const evt: IEnvironment;
export declare class EnvironmentService extends SDKEnvironmentService {
    protected configService: ConfigService<IEnvironment>;
    constructor(configService: ConfigService<IEnvironment>);
    get evt(): IEnvironment;
    createMulterOptions(): MulterModuleOptions;
    extractEnvironmentData(_evt: ISDKEnvironment): void;
}
