"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentService = exports.evt = exports.IEnvironment = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const multer = require("multer");
class IEnvironment extends la_nest_library_1.ISDKEnvironment {
    constructor() {
        super(...arguments);
        this.LOGS_DEST = null;
        this.THEME = null;
        this.SYNCHRONIZE = null;
        this.timestampDifferenceFromGMT = null;
        this.APP_NAME = null;
        this.CA = null;
        this.CERT = null;
        this.KEY = null;
        this.PS_SECRET_KEY = null;
        this.PS_PUBLIC_KEY = null;
        this.UPLOADS_ABS_PATH = null;
        this.REALTIME_INTERVAL_MIN = 5;
        this.R2_ACCOUNT_ID = null;
        this.R2_ACCESS_KEY_ID = null;
        this.R2_SECRET_ACCESS_KEY = null;
        this.R2_BUCKET_NAME = null;
        this.CLOUDFLARE_EMAIL = null;
        this.CLOUDFLARE_API_KEY = null;
        this.CLOUDFLARE_ACCOUNT_ID = null;
        this.FFMPEG_PATH = null;
        this.FFPROBE_PATH = null;
    }
}
exports.IEnvironment = IEnvironment;
exports.evt = new IEnvironment();
let EnvironmentService = class EnvironmentService extends la_nest_library_1.SDKEnvironmentService {
    constructor(configService) {
        super(configService);
        this.configService = configService;
    }
    get evt() {
        return exports.evt;
    }
    createMulterOptions() {
        return {
            storage: multer.memoryStorage(),
        };
    }
    extractEnvironmentData(_evt) {
        for (const key in _evt)
            if (Object.prototype.hasOwnProperty.call(_evt, key)) {
                let v = this.configService.get(key, {
                    infer: true,
                });
                if (v == 'true')
                    v = true;
                else if (v == 'false')
                    v = false;
                exports.evt[key] = _evt[key] = v;
            }
        (0, la_nest_library_1.setSDKEnvironment)(exports.evt);
    }
};
exports.EnvironmentService = EnvironmentService;
exports.EnvironmentService = EnvironmentService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], EnvironmentService);
//# sourceMappingURL=environment.service.js.map