import { BaseService } from '../base.service';
import { FindOptionsWhere, Repository } from 'typeorm';
import { PartnerEntity } from '../../entities/partner.entity';
import { EPartnerType } from '../../enums/partner.enum';
import { CreatePartnerDTO, SearchPartnerDTO } from '../../dtos/partner.dto';
import { ICreateConfig, ISearchQueryItem } from '@serene-dev/la-nest-library';
import { UsersService } from '../../modules/authentication/services/users.service';
export declare abstract class PartnerService<TSearchDto extends SearchPartnerDTO = SearchPartnerDTO> extends BaseService<PartnerEntity, TSearchDto> {
    repo: Repository<PartnerEntity>;
    usersService: UsersService;
    readonly type: EPartnerType;
    protected baseQueryStruct: ISearchQueryItem<SearchPartnerDTO>[];
    constructor(repo: Repository<PartnerEntity>, type: EPartnerType, usersService: UsersService);
    getWhere(where: FindOptionsWhere<PartnerEntity> | FindOptionsWhere<PartnerEntity>[]): Promise<PartnerEntity[]>;
    _createChecks(data: CreatePartnerDTO): Promise<void>;
    protected _createFunction(requestData: CreatePartnerDTO, config?: ICreateConfig): Promise<PartnerEntity>;
    _create(data: CreatePartnerDTO, config?: ICreateConfig): Promise<PartnerEntity>;
}
