"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartnerService = void 0;
const common_1 = require("@nestjs/common");
const base_service_1 = require("../base.service");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const base_enum_1 = require("../../enums/base.enum");
const partner_entity_1 = require("../../entities/partner.entity");
const partner_enum_1 = require("../../enums/partner.enum");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const users_service_1 = require("../../modules/authentication/services/users.service");
const authentication_enum_1 = require("../../modules/authentication/enums/authentication.enum");
let PartnerService = class PartnerService extends base_service_1.BaseService {
    constructor(repo, type, usersService) {
        super(repo, base_enum_1.ETableName.partner);
        this.repo = repo;
        this.usersService = usersService;
        this.baseQueryStruct = [
            { field: 'phoneNumber', condition: la_nest_library_1.ESearchCondition.contains },
            { field: 'email', condition: la_nest_library_1.ESearchCondition.contains },
            { field: 'name', condition: la_nest_library_1.ESearchCondition.contains },
        ];
        this.queryStruct = this.baseQueryStruct;
        this.type = type;
    }
    getWhere(where) {
        return this.repo.find({ where: { ...where, type: this.type } });
    }
    async _createChecks(data) {
        data.name = data.name.trim();
        data.email = data.email.trim();
        await this.checkIfUniqueBy([
            {
                name: (0, typeorm_1.Like)(data.name),
            },
            {
                email: (0, typeorm_1.Like)(data.email),
            },
        ], {
            errorMessage: `Name or Email already exists`,
        });
    }
    async _createFunction(requestData, config) {
        const data = this.repo.create({ ...requestData, type: this.type });
        let ret;
        const saveFunction = async (manager) => {
            ret = await manager.save(data);
            await this.usersService.createUser({
                firstname: requestData.name,
                lastname: 'Admin',
                login: false,
                type: authentication_enum_1.EAuthType.provider,
                email: requestData.email,
                phoneNumber: requestData.phoneNumber,
                orgID: ret.id,
            });
        };
        config?.entityManager
            ? await saveFunction(config?.entityManager)
            : await this.repo.manager.transaction(saveFunction);
        return ret;
    }
    _create(data, config) {
        return super._create(data, config);
    }
};
exports.PartnerService = PartnerService;
exports.PartnerService = PartnerService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(partner_entity_1.PartnerEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository, String, users_service_1.UsersService])
], PartnerService);
//# sourceMappingURL=partner.service.js.map