import { SDKWalletService, SDKWalletTransactionService } from '@serene-dev/la-nest-library';
import { EntityManager, Repository } from 'typeorm';
import { CreatePartnerDTO } from '../../dtos/partner.dto';
import { PartnerEntity } from '../../entities/partner.entity';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { PartnerService } from './partner.service';
import { CreateWalletTransactionDTO } from '@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.dto';
import { TokenService, TokenSessionService } from '@serene-dev/la-nest-library/dist/libs/la-library/src/services/token.service';
import { ProviderUsersService } from '../../modules/authentication/services/provider-users.service';
export declare class ProviderService extends PartnerService {
    repo: Repository<PartnerEntity>;
    tokenService: TokenService;
    usersService: ProviderUsersService;
    tokenSessionService: TokenSessionService;
    walletService: SDKWalletService;
    walletTransactionService: SDKWalletTransactionService;
    static path: string;
    constructor(repo: Repository<PartnerEntity>, tokenService: TokenService, usersService: ProviderUsersService, tokenSessionService: TokenSessionService, walletService: SDKWalletService, walletTransactionService: SDKWalletTransactionService);
    getOrCreateWallet(clientID: string, config?: {
        entityManager: EntityManager;
    }): Promise<import("@serene-dev/la-nest-library").SDKWalletGrossBalanceView>;
    topupWallet(clientID: string, body: CreateWalletTransactionDTO): Promise<import("@serene-dev/la-nest-library").SDKWalletTransaction>;
    setupTestClient(): Promise<PartnerEntity>;
    generateKeyExt(auth: IAuthParam, clientID: string): Promise<void>;
    protected generateKey(client: PartnerEntity, auth?: IAuthParam): Promise<void>;
    protected _preCreateFunction(data: Partial<PartnerEntity>): Promise<void>;
    protected _postCreateFunction(requestData: CreatePartnerDTO, savedData: PartnerEntity): Promise<void>;
    authToProvider(auth: IAuthParam): Promise<PartnerEntity>;
}
