"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const typeorm_2 = require("typeorm");
const partner_entity_1 = require("../../entities/partner.entity");
const partner_enum_1 = require("../../enums/partner.enum");
const utility_service_1 = require("../utility.service");
const partner_service_1 = require("./partner.service");
const token_service_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/services/token.service");
const authentication_enum_1 = require("../../modules/authentication/enums/authentication.enum");
const provider_users_service_1 = require("../../modules/authentication/services/provider-users.service");
let ProviderService = class ProviderService extends partner_service_1.PartnerService {
    constructor(repo, tokenService, usersService, tokenSessionService, walletService, walletTransactionService) {
        super(repo, partner_enum_1.EPartnerType.provider, usersService);
        this.repo = repo;
        this.tokenService = tokenService;
        this.usersService = usersService;
        this.tokenSessionService = tokenSessionService;
        this.walletService = walletService;
        this.walletTransactionService = walletTransactionService;
    }
    async getOrCreateWallet(clientID, config) {
        if (!clientID)
            utility_service_1.UtilityClass.throwError({ message: 'Client id is missing' });
        const client = await this.repo.findOne({
            where: { id: clientID },
            relations: { wallet: true },
            select: { id: true, walletId: true, name: true },
        });
        if (!client)
            utility_service_1.UtilityClass.throwError({ message: 'Client could not be found' });
        else if (!client.walletId) {
            const wallet = await this.walletService._create({
                name: client.name,
                active: true,
                allowOverdraft: false,
                userID: client.id,
                type: this.type,
            }, { entityManager: config?.entityManager });
            client.walletId = wallet.id;
            await this._updateByID(clientID, { walletId: wallet.id });
        }
        return this.walletService.getComputed({ id: client.walletId });
    }
    async topupWallet(clientID, body) {
        const wallet = await this.getOrCreateWallet(clientID);
        return this.walletTransactionService.create(wallet.id, body);
    }
    async setupTestClient() {
        const testEmail = 'ahmeddapo0110@outlook.com';
        const client = await this.getSingle({
            email: testEmail,
        });
        return !client
            ? await this._create({ name: 'Test', email: testEmail })
            : client;
    }
    async generateKeyExt(auth, clientID) {
        const partner = await this.getSingle(clientID && auth.userType == authentication_enum_1.EAuthType.admin
            ? { id: clientID }
            : { manager: { auth: { id: auth.id } } });
        if (!partner)
            utility_service_1.UtilityClass.throwError({ message: `Client was not found` });
        return await this.generateKey(partner, auth);
    }
    async generateKey(client, auth) {
        const token = await this.tokenService.generateToken({ id: client.id, isProviderAPI: true }, { expiresIn: '1y' });
        await this.tokenSessionService._create({
            ownerID: client.id,
            token: token.token,
            creator: { id: auth?.id || client?.creatorId },
        });
        await this._updateByID(client.id, { apiKey: token.token });
        if (client.email)
            la_nest_library_1.MailService.sendMail({
                to: client.email,
                html: await utility_service_1.UtilityClass.emailTemplater(`New API Key`, `A new API key has been generated for your account ${client.name}. <br> API key: <strong>${token.token}</strong>`),
                subject: `New API Key`,
                _senderName: 'Account Manager',
            });
    }
    async _preCreateFunction(data) {
        data.active = false;
    }
    async _postCreateFunction(requestData, savedData) {
        await this.generateKey(savedData);
        await this.getOrCreateWallet(savedData.id);
        return super._postCreateFunction(requestData, savedData);
    }
    async authToProvider(auth) {
        let res;
        if (auth.isProviderAPI)
            res = await this.getSingle({ id: auth.id });
        else if (auth.userType == authentication_enum_1.EAuthType.provider)
            res = await this.getSingle({ users: { auth: { id: auth.id } } });
        if (!res)
            utility_service_1.UtilityClass.throwError({ message: `Client doesn't exist` });
        return res;
    }
};
exports.ProviderService = ProviderService;
ProviderService.path = 'providers';
exports.ProviderService = ProviderService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(partner_entity_1.PartnerEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        token_service_1.TokenService,
        provider_users_service_1.ProviderUsersService,
        token_service_1.TokenSessionService,
        la_nest_library_1.SDKWalletService,
        la_nest_library_1.SDKWalletTransactionService])
], ProviderService);
//# sourceMappingURL=provider.service.js.map