import { Subject } from 'rxjs';
import { HttpService } from '@nestjs/axios';
import { EVerificationStatus } from '../modules/subscription/subscription.enum';
import { PricingEntity } from '../modules/pricing/pricing.entity';
type IQueueItem = {
    reference: any;
    pricing: PricingEntity;
    cb: (status: EVerificationStatus) => Promise<any>;
};
export declare class PaystackService {
    protected http: HttpService;
    private readonly logger;
    private readonly baseURL;
    private readonly verificationQueue;
    private readonly verifyPaystack$;
    readonly verifyPaystackComplete$: Subject<void>;
    constructor(http: HttpService);
    private initializeVerificationQueue;
    private getAxiosConfig;
    addToVerification(qi: IQueueItem): void;
    protected verifyTransaction(reference: string): Promise<void>;
    fetchBanks(): Promise<IPaystackBank[]>;
}
export declare class PaystackServiceModule {
}
interface IPSResp<T> {
    status: boolean;
    message: string;
    data: T;
}
interface ITransferResponse {
    integration: number;
    domain: string;
    amount: number;
    currency: string;
    source: string;
    reason: string;
    recipient: number;
    status: string;
    transfer_code: string;
    id: number;
    createdAt: string;
    updatedAt: string;
}
export type IPaystackTransferResponse = IPSResp<ITransferResponse>;
interface IPaystackBank {
    name: string;
    slug: string;
    code: string;
    longcode: string;
    gateway?: any;
    pay_with_bank: boolean;
    active: boolean;
    is_deleted: boolean;
    country: string;
    currency: string;
    type: string;
    id: number;
    createdAt: string;
    updatedAt: string;
}
export {};
