"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var PaystackService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaystackServiceModule = exports.PaystackService = void 0;
const common_1 = require("@nestjs/common");
const axios_1 = require("axios");
const lodash_1 = require("lodash");
const rxjs_1 = require("rxjs");
const axios_2 = require("@nestjs/axios");
const subscription_enum_1 = require("../modules/subscription/subscription.enum");
const environment_service_1 = require("./environment.service");
let PaystackService = PaystackService_1 = class PaystackService {
    constructor(http) {
        this.http = http;
        this.logger = new common_1.Logger(PaystackService_1.name);
        this.baseURL = 'https://api.paystack.co/';
        this.verificationQueue = new Map([]);
        this.verifyPaystack$ = new rxjs_1.Subject();
        this.verifyPaystackComplete$ = new rxjs_1.Subject();
        this.initializeVerificationQueue();
    }
    initializeVerificationQueue() {
        this.verifyPaystack$
            .pipe((0, rxjs_1.tap)((v) => (v ? this.verificationQueue.set(v.reference, v) : null)), (0, rxjs_1.debounceTime)(500), (0, rxjs_1.exhaustMap)(() => {
            const nextRef = this.verificationQueue.entries().next()
                .value?.[0];
            if (!nextRef)
                return (0, rxjs_1.of)(null);
            return this.verifyTransaction(nextRef);
        }))
            .subscribe(() => {
            if (this.verificationQueue.size) {
                this.verifyPaystack$.next(null);
            }
            else {
                this.verifyPaystackComplete$.next();
            }
        });
    }
    getAxiosConfig(isProd = true) {
        const key = isProd ? environment_service_1.evt.PS_SECRET_KEY : environment_service_1.evt.PS_SECRET_KEY;
        return {
            headers: { Authorization: `Bearer ${key}` },
        };
    }
    addToVerification(qi) {
        this.verifyPaystack$.next(qi);
    }
    async verifyTransaction(reference) {
        const qItem = this.verificationQueue.get(reference);
        try {
            const response = await axios_1.default.get(`${this.baseURL}transaction/verify/${reference}`, this.getAxiosConfig());
            let status;
            const data = response.data.data;
            if (data.status === 'success' &&
                qItem.pricing.amount === data.amount / 100) {
                status = subscription_enum_1.EVerificationStatus.verified;
            }
            else if (data.status === 'error') {
                status = subscription_enum_1.EVerificationStatus.failed;
            }
            if (status) {
                await qItem.cb(status);
                this.verificationQueue.delete(reference);
            }
        }
        catch (error) {
            if (error?.response?.data?.code === 'transaction_not_found') {
                await qItem.cb(subscription_enum_1.EVerificationStatus.failed);
                this.verificationQueue.delete(reference);
            }
            this.logger.error(`Transaction verification failed: ${error.message}`);
        }
    }
    async fetchBanks() {
        try {
            const response = await axios_1.default.get(`${this.baseURL}bank?country=nigeria`, this.getAxiosConfig(true));
            return (0, lodash_1.uniqBy)(response.data.data.sort((a, b) => a.name.localeCompare(b.name)), 'code');
        }
        catch (error) {
            throw error.response?.data?.message || 'Failed to fetch banks';
        }
    }
};
exports.PaystackService = PaystackService;
exports.PaystackService = PaystackService = PaystackService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [axios_2.HttpService])
], PaystackService);
let PaystackServiceModule = class PaystackServiceModule {
};
exports.PaystackServiceModule = PaystackServiceModule;
exports.PaystackServiceModule = PaystackServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [axios_2.HttpModule],
        providers: [PaystackService],
        exports: [PaystackService],
    })
], PaystackServiceModule);
//# sourceMappingURL=paystack.service.js.map